-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("defeat")
  self:AddTriggerTarget("victory")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true  
    self.defeated = false
    self.p0 = Citadels.GetPlayer(0)
        
    if not self.loaded then
      self.victory = 0
      self.timer = 4  
			MarkMainGoal(self)
    end    
  end
   
  if self.defeated then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.p0:FailQuest('D2G_GOAL_1')
      self.p0:FailQuest('D2G_GOAL_2')
      self.p0:FailQuest('D2G_GOAL_3')
      Citadels.ForceDefeat()
    end
  end
  
  if self.victory == 3 then
    self.p0:WinQuest('D2G_GOAL_2')
    self.p0:WinQuest('D2G_GOAL_3')
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
	  Citadels.SetAchievementDone(9)
      Citadels.ForceVictory()
    end
  end
end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("questTown"):GetPosition().x
  gPosY = Game:GetEntity("questTown"):GetPosition().y

  self.p0:AddQuest('D2G_GOAL_1','main')
  self.p0:SetQuestPosition('D2G_GOAL_1', gPosX, gPosY)
end


function OnTrigger(self, source, target)
  if target == "defeat" then
    self.defeated = true
  elseif target == "victory" then
    self.victory = self.victory + 1
  end  
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  --OnAfterSceneLoaded(self)
	  self.loaded = true
	  self.victory = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.victory)
    ar:Write(self.timer)
  end  
end

